/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.factories;

import com.badlogic.gdx.math.RandomXS128;
import com.google.inject.Inject;
import java.util.Random;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;

public class FurnitureEntityAttributesFactory {
    private final FurnitureTypeDictionary furnitureTypeDictionary;
    private final Random random = new RandomXS128();

    @Inject
    public FurnitureEntityAttributesFactory(FurnitureTypeDictionary furnitureTypeDictionary) {
        this.furnitureTypeDictionary = furnitureTypeDictionary;
    }

    public FurnitureEntityAttributes byName(String furnitureTypeName, GameMaterial primaryMaterial) {
        FurnitureEntityAttributes attributes = new FurnitureEntityAttributes(this.random.nextLong());
        attributes.setFurnitureType(this.furnitureTypeDictionary.getByName(furnitureTypeName));
        attributes.setPrimaryMaterialType(primaryMaterial.getMaterialType());
        attributes.getMaterials().put(primaryMaterial.getMaterialType(), primaryMaterial);
        return attributes;
    }

    public FurnitureEntityAttributes byType(FurnitureType furnitureType, GameMaterial primaryMaterial) {
        FurnitureEntityAttributes attributes = new FurnitureEntityAttributes(this.random.nextLong());
        attributes.setFurnitureType(furnitureType);
        attributes.setPrimaryMaterialType(primaryMaterial.getMaterialType());
        attributes.getMaterials().put(primaryMaterial.getMaterialType(), primaryMaterial);
        return attributes;
    }
}

